<?php

namespace Sale\Handlers\PaySystem;

use Bitrix\Main\Error;
use Bitrix\Main\Localization\Loc;
use Bitrix\Main\Request;
use Bitrix\Main\Text\Encoding;
use Bitrix\Main\Type\DateTime;
use Bitrix\Main\Web;
use Bitrix\Sale\BusinessValue;
use Bitrix\Sale\PaySystem;
use Bitrix\Sale\Payment;
use Bitrix\Sale\Order;
use Bitrix\Main\Loader;
use Bitrix\Main\Config\Option;
use Bitrix\Main;
IncludeModuleLangFile(__FILE__);
require_once dirname(dirname(__FILE__)) . '/config.php';

define('DEF_MODULE_ID', $RBS_CONFIG['MODULE_ID']);
define('DEF_FISCAL', $RBS_CONFIG['RBS_ENABLE_FISCALE_OPTIONS']);
define('RBS_PROD_URL_ALT', $RBS_CONFIG['RBS_PROD_URL_ALT']);
define('RBS_PROD_URL_ALT_PREFIX', $RBS_CONFIG['RBS_PROD_URL_ALT_PREFIX']);

define('RBS_PROD_URL_ALTERNATIVE_DOMAIN', $RBS_CONFIG['RBS_PROD_URL_ALTERNATIVE_DOMAIN']);
define('RBS_TEST_URL_ALTERNATIVE_DOMAIN', $RBS_CONFIG['RBS_TEST_URL_ALTERNATIVE_DOMAIN']);

Loader::includeModule( 'rbs.payment' );
/**
 * Class rbsPaymentHandler
 * @package Sale\Handlers\PaySystem
 */
class rbs_paymentHandler extends PaySystem\ServiceHandler implements PaySystem\IPrePayable
{
	/**
	 * @param Payment $payment
	 * @param Request|null $request
	 * @return PaySystem\ServiceResult
	 */
	public function initiatePay(Payment $payment, Request $request = null)
	{

		$moduleId = 'rbs.payment';
		
		$RBS_Gateway = new \Rbs\Payments\Gateway;

		$api_login = $this->getBusinessValue($payment, 'API_LOGIN');
		$prod_gate_url = $this->getGateProdUrl($api_login,RBS_PROD_URL_ALT_PREFIX, Option::get($moduleId, 'RBS_PROD_URL'), RBS_PROD_URL_ALT);

		// module settings
		$RBS_Gateway->setOptions(array(
			'module_id' => Option::get($moduleId, 'MODULE_ID'),
			'gate_url_prod' => $prod_gate_url,
			'gate_url_prod_alt' => strlen(RBS_PROD_URL_ALTERNATIVE_DOMAIN) > 0 ? RBS_PROD_URL_ALTERNATIVE_DOMAIN : $prod_gate_url,
			'gate_url_test' => Option::get($moduleId, 'RBS_TEST_URL'),
			'gate_url_test_alt' => strlen(RBS_TEST_URL_ALTERNATIVE_DOMAIN) > 0 ? RBS_TEST_URL_ALTERNATIVE_DOMAIN : Option::get($moduleId, 'TEST_URL'),
			'module_version' => Option::get($moduleId, 'MODULE_VERSION'),
			'iso' => unserialize(Option::get($moduleId, 'ISO')),
			'cms_version' => 'Bitrix ' . SM_VERSION,
			'language' => 'ru',
			'default_cartItem_tax' => Option::get($moduleId, 'TAX_DEFAULT'),
			'ignore_product_tax' => Option::get($moduleId, 'IGNORE_PRODUCT_TAX'), 
			'callback_mode' => Option::get($moduleId, 'RBS_ENABLE_CALLBACK'),
			'measurement_code' => Option::get($moduleId, 'MEASUREMENT_CODE'),
			'enable_cacert' => $this->getBusinessValue($payment, 'API_ENABLE_CACERT')  == 'Y' ? true : false,
			'callback_actions' => unserialize(Option::get($moduleId, 'CALLBACK_ACTIONS')),
			'callback_action_order_status' => unserialize(Option::get($moduleId, 'CALLBACK_ACTION_ORDER_STATUS')),
			'callback_type' =>  Option::get($moduleId, 'RBS_CALLBACK_TYPE') === 'DYNAMIC' ? 'DYNAMIC' : 'STATIC',
		));

		// handler settings
		$RBS_Gateway->setOptions(array(
			'ofd_tax' => $this->getBusinessValue($payment, 'OFD_TAX_SYSTEM') == 0 ? 0 : $this->getBusinessValue($payment, 'OFD_TAX_SYSTEM'),
			'ofd_enabled' => $this->getBusinessValue($payment, 'OFD_RECIEPT')  == 'Y' && DEF_FISCAL ? 1 : 0,
			'ffd_version' => $this->getBusinessValue($payment, 'FFD_VERSION'),
			'ffd_payment_object' => $this->getBusinessValue($payment, 'FFD_PAYMENT_OBJECT'),
			'ffd_payment_object_delivery' => $this->getBusinessValue($payment, 'FFD_PAYMENT_OBJECT_DELIVER'),
			'ffd_payment_method' => $this->getBusinessValue($payment, 'FFD_PAYMENT_METHOD'),
			'test_mode' => $this->getBusinessValue($payment, 'API_TEST_MODE') == 'Y' ? 1 : 0,
			'handler_logging' => $this->getBusinessValue($payment, 'HANDLER_LOGGING') == 'Y' ? 1 : 0,
			'handler_two_stage' => $this->getBusinessValue($payment, 'HANDLER_TWO_STAGE') == 'Y' ? 1 : 0,
			'fes_cashboxId' => Option::get($moduleId, 'RBS_ENABLE_FES_CODES') ? $this->getBusinessValue($payment, 'RBS_FES_CASHBOX_ID') : "",
			'enable_order_payer_data' => Option::get($moduleId, 'RBS_ENABLE_ORDER_PAYER_DATA'),
		));

		$RBS_Gateway->buildData(array(
			'orderNumber' => $this->getBusinessValue($payment, 'RBS_ORDER_NUMBER') . '_' . $payment->getField('ID'),
		    'amount' => $this->getBusinessValue($payment, 'RBS_ORDER_AMOUNT'),
		    'userName' => $this->getBusinessValue($payment, 'API_LOGIN'),
		    'password' => $this->getBusinessValue($payment, 'API_PASSWORD'),
		    'description' => $this->getOrderDescription($payment),
		));

		$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== "off" ? 'https://' : 'http://';
		$domain_name = $_SERVER['HTTP_HOST'];

		if(strlen($domain_name) < 3) {
			$domain_name = $_SERVER['SERVER_NAME'];
			//$domain_name = Option::get($moduleId, 'NOTIFY_URL', '');
		}

		if(strlen($domain_name) > 3 && Option::get($moduleId, 'RBS_ENABLE_CALLBACK') == true) {
			$RBS_Gateway->setOptions(
				array(
					'domain_found' => true,
					'callback_url' => html_entity_decode($protocol . $domain_name . '/bitrix/tools/sale_ps_result.php?PAYMENT=RBS&OPERATION_CALLBACK=RBS')
				)
			);
		}
		$RBS_Gateway->buildData(array(
		    'returnUrl' => $protocol . $domain_name . $site_dir  . '/bitrix/tools/sale_ps_result.php' . '?PAYMENT=RBS&ORDER_ID=' . $payment->getField('ORDER_ID') . '&PAYMENT_ID=' . $payment->getField('ID')
		));
		if (Option::get($moduleId, 'RBS_CALLBACK_TYPE')) {
			$RBS_Gateway->buildData(array(
				'dynamicCallbackUrl' => $protocol . $domain_name . '/bitrix/tools/sale_ps_result.php' . '?PAYMENT=RBS&ORDER_ID=' . $payment->getField('ORDER_ID') . '&PAYMENT_ID=' . $payment->getField('ID') . '&OPERATION_CALLBACK=RBS&OPERATION_TYPE=DYNAMIC',
			));
		}
		$Order = Order::load($payment->getOrderId());
		$propertyCollection = $Order->getPropertyCollection();
		
		$phone_key = strlen(Option::get($moduleId, 'OPTION_PHONE')) > 0 ? Option::get($moduleId, 'OPTION_PHONE') : 'PHONE';
		$email_key = strlen(Option::get($moduleId, 'OPTION_EMAIL')) > 0 ? Option::get($moduleId, 'OPTION_EMAIL') : 'EMAIL';
		$fio_key = strlen(Option::get($moduleId, 'OPTION_FIO')) > 0 ? Option::get($moduleId, 'OPTION_EMAIL') : 'FIO';

		$phone = preg_replace('/\D+/', '', $this->getPropertyValueByCode($propertyCollection, $phone_key));

		if(substr($phone, 0, 1) == '7') {
			$phone = '+'.$phone;
		}
		if(substr($phone, 0, 1) == '8') {
		    $phone[0] = '7';
			$phone = '+' . $phone;
		}

		$RBS_Gateway->setOptions(array(
			'customer_name' => $this->getPropertyValueByCode($propertyCollection, $fio_key),
			'customer_email' => $this->getPropertyValueByCode($propertyCollection, $email_key),
			'customer_phone' => $phone,
		));
		if ($RBS_Gateway->ofdEnable() && DEF_FISCAL) {
			$Basket = $Order->getBasket();
			$basketItems = $Basket->getBasketItems();

			$positions = array();
			$lastIndex = 0;
			$nomenclature_code_value = Option::get($moduleId, 'NOMECLATURE_CODE_VALUE');

			foreach ($basketItems as $key => $BasketItem) {
				$fes_truCode = false;
				$nomenclature_code_value = Option::get($moduleId, 'NOMECLATURE_CODE_VALUE');
			
				if(Option::get($moduleId, 'RBS_ENABLE_FES_CODES') || Option::get($moduleId, 'RBS_ENABLE_NOMECLATURE')) {
					$productId = $BasketItem->getProductId(); // Получаем ID товара
				    // Запрашиваем свойство "FES" у товара из инфоблока
				    $productData = \CIBlockElement::GetList(
				        [],
				        ['ID' => $productId],
				        false,
				        false,
				        ['ID', 'IBLOCK_ID', 'PROPERTY_FES_TRUCODE','PROPERTY_' . $nomenclature_code_value]
				    );
				    if ($product = $productData->GetNext()) {
				        $fes_truCode = $product['PROPERTY_FES_TRUCODE_VALUE'] ? $product['PROPERTY_FES_TRUCODE_VALUE'] : false;
				        $nomenclature = $product['PROPERTY_'.  strtoupper($nomenclature_code_value) .'_VALUE'] ? $product['PROPERTY_'.  strtoupper($nomenclature_code_value) .'_VALUE'] : false;
				    }
			    }
				$lastIndex = $key + 1;
		        $positions[] = array(
		            'positionId' => $key,
		            'itemCode' => $BasketItem->getProductId(),
		            'name' => $BasketItem->getField('NAME'),
		            'itemAmount' => $BasketItem->getFinalPrice(),
		            'itemPrice' => $BasketItem->getPrice(),
		            'quantity' => array(
		                'value' => $BasketItem->getQuantity(),
		                'measure' => $BasketItem->getField('MEASURE_NAME') ? $BasketItem->getField('MEASURE_NAME') : Loc::getMessage('RBS_FIELD_MEASURE'),
		            ),
		            'tax' => array(
		                'taxType' =>  $RBS_Gateway->getTaxCode( $BasketItem->getField('VAT_RATE')),
		            ),
		            'fes_truCode' => $fes_truCode,
		            'nomenclature' => $nomenclature,
		        );
			}

			if($Order->getField('PRICE_DELIVERY') > 0) {
				
				Loader::includeModule('catalog');
				$deliveryInfo = \Bitrix\Sale\Delivery\Services\Manager::getById($Order->getField('DELIVERY_ID'));

				$deliveryVatItem = \CCatalogVat::GetByID($deliveryInfo['VAT_ID'])->Fetch();
				$RBS_Gateway->setOptions(array(
				    'delivery' => true,
				));
				$positions[] = array(
		            'positionId' => $lastIndex + 1,
		            'itemCode' => 'DELIVERY_' . $Order->getField('DELIVERY_ID'),
		            'name' => Loc::getMessage('RBS_FIELD_DELIVERY'),
		            'itemAmount' => $Order->getField('PRICE_DELIVERY'),
		            'itemPrice' => $Order->getField('PRICE_DELIVERY'),
		            'quantity' => array(
		                'value' => 1,
		                'measure' => Loc::getMessage('RBS_FIELD_MEASURE'),
		            ),
		            'tax' => array(
		                'taxType' => $RBS_Gateway->getTaxCodeDelivery($deliveryVatItem['RATE']),
		            ),
		        );
			}

			if(Option::get($moduleId, 'DISCOUNT_HELPER')) {
		     // DISCOUNT CALCULATE
			    $RBS_Discount = new \Rbs\Payments\Discount;
				$result_order_sum = $Order->getPrice() - $Order->getSumPaid();
	            $discount = $RBS_Discount->discoverDiscount($result_order_sum,$positions);
	            if($discount > 0) { 
	                $RBS_Discount->setOrderDiscount($discount);
	                $recalculatedPositions = $RBS_Discount->normalizeItems($positions);
	                $recalculatedAmount = $RBS_Discount->getResultAmount();
	                $positions = $recalculatedPositions;
	            }
            }

            
            foreach ($positions as $key => $position) {
				$RBS_Gateway->setPosition($position);
			}
		}

		$gateResponse = $RBS_Gateway->registerOrder();

		$params = array(
	        'rbs_result' => $gateResponse,
	        'payment_link' => $RBS_Gateway->getPaymentLink(),
	        'currency' => $payment->getField('CURRENCY')
	    );
	    $this->setExtraParams($params);

	    return $this->showTemplate($payment, "payment");
	}

	public function processRequest(Payment $payment, Request $request)
	{
		global $APPLICATION;
		$moduleId = 'rbs.payment';
		$result = new PaySystem\ServiceResult();
		$order = Order::load($payment->getOrderId());

		$handler_logging =  $this->getBusinessValue($payment, 'HANDLER_LOGGING') == 'Y' ? 1 : 0;

		$RBS_Gateway = new \Rbs\Payments\Gateway;

		$api_login = $this->getBusinessValue($payment, 'API_LOGIN');
		$prod_gate_url = $this->getGateProdUrl($api_login,RBS_PROD_URL_ALT_PREFIX, Option::get($moduleId, 'RBS_PROD_URL'), RBS_PROD_URL_ALT);

		$RBS_Gateway->setOptions(array(
			// module settings
			'gate_url_prod' => $prod_gate_url,
			'gate_url_test' => Option::get($moduleId, 'RBS_TEST_URL'),
			'test_mode' => $this->getBusinessValue($payment, 'API_TEST_MODE') == 'Y' ? 1 : 0,
			'callback_redirect' => $request->get('CALLBACK_REDIRECT') == 1 ? 1 : 0,
			'handler_logging' => $handler_logging,
			'callback_operation' => $request->get('operation')
		));

		$RBS_Gateway->buildData(array(
		    'userName' => $this->getBusinessValue($payment, 'API_LOGIN'),
		    'password' => $this->getBusinessValue($payment, 'API_PASSWORD'),
		    'orderId' => $request->get('CALLBACK_REDIRECT') == 1 ? $request->get('mdOrder') : $request->get('orderId'),
		));
		
		$gateResponse = $RBS_Gateway->checkOrder();

		$resultId = explode("_", $gateResponse['orderNumber'] );
        array_pop($resultId);
        $res_payment_id = array_pop($resultId);
        $resultId = implode('_', $resultId);

        $successPayment = true;

        $order_status_map_callback = [
		    0 => 'FALSE',
		    1 => 'approved',
		    2 => 'deposited',
		    3 => 'reversed',
		    4 => 'refunded',
		    5 => 'FALSE',
		    6 => 'declinedByTimeout',
		];
		
		$operation_name = $order_status_map_callback[$gateResponse['orderStatus']];
        
        if($resultId != $this->getBusinessValue($payment, 'RBS_ORDER_NUMBER')) {
			$successPayment = false;
		}
        if( $gateResponse['errorCode'] != 0 || ($gateResponse['orderStatus'] != 1 && $gateResponse['orderStatus'] != 2) ) {
        	$successPayment = false;
        }

        // Order canceled by tymeout
        if($request->get('operation') === 'declinedByTimeout' 
        	&& Option::get($moduleId, 'CANCEL_ORDER_BY_TIMEOUT')
        	&& $request->get('CALLBACK_REDIRECT') == 1 
        	&& !$payment->isPaid()
        ) {
        	$this->cancelOrder($payment->getOrderId());
        	return $result;
        }
        

        if ($successPayment && $request->get('operation') == 'deposited' && !$payment->isPaid() && ($request->get('CALLBACK_REDIRECT') == 1 || !Option::get($moduleId, 'RBS_ENABLE_CALLBACK'))) {

			$inputJson = self::encode($request->toArray());

			$fields = array(
				'PS_INVOICE_ID' => $request->get('CALLBACK_REDIRECT') == 1 ? $request->get('mdOrder') : $request->get('orderId'),
				"PS_STATUS_CODE" => $gateResponse['orderStatus'],
				"PS_STATUS_DESCRIPTION" => $gateResponse["cardAuthInfo"]["pan"] . ";" . $gateResponse['cardAuthInfo']["cardholderName"],
				"PS_SUM" => $gateResponse["amount"] / 100,
				"PS_STATUS" => 'Y',

				"PS_CURRENCY" => $gateResponse["currency"],
				"PS_RESPONSE_DATE" => new DateTime()
			);

			$result->setOperationType(PaySystem\ServiceResult::MONEY_COMING);
			$result->setPsData($fields);


			// set delivery status
			if ($this->getBusinessValue($payment, 'HANDLER_SHIPMENT') == 'Y') {
				$shipmentCollection = $order->getShipmentCollection();
				foreach ($shipmentCollection as $shipment) {
					if (!$shipment->isSystem()) {
						$shipment->allowDelivery();
					}
				}
			}
        }


		$is_need_payment_cancel = Option::get($moduleId, 'CANCEL_PAYMENT_BY_REFUNDED');

		// Payment reversed
		if($payment->isPaid() && $gateResponse['orderStatus'] === 3 && $request->get('CALLBACK_REDIRECT') == 1) {

			$fields = array( "PS_RESPONSE_DATE" => new DateTime());

			$is_part_cancel = $gateResponse['paymentAmountInfo']['approvedAmount'] > 0 && $gateResponse['paymentAmountInfo']['approvedAmount'] < $gateResponse['amount'];
			$is_full_cancel = $gateResponse['paymentAmountInfo']['approvedAmount'] === 0;

			if($is_full_cancel) {
				$fields['PS_STATUS_MESSAGE'] = Loc::getMessage('RBS_PAYMENT_CANCEL_FULL_MESSAGE') . ($gateResponse['amount'] / 100) . Loc::getMessage('RBS_PAYMENT_R');
			} else if($is_part_cancel) {
				$cancel_summ = $gateResponse['amount'] - $gateResponse['paymentAmountInfo']['approvedAmount'];
				$fields['PS_STATUS_MESSAGE'] = Loc::getMessage('RBS_PAYMENT_CANCEL_MESSAGE') . ($cancel_summ / 100) . Loc::getMessage('RBS_PAYMENT_R');
			}

			if ($is_need_payment_cancel && $is_full_cancel) {
				$result->setOperationType(PaySystem\ServiceResult::MONEY_LEAVING);
			}

			$result->setPsData($fields);
		}


		// Payment refund
		if($payment->isPaid() && $gateResponse['orderStatus'] === 4 && $request->get('CALLBACK_REDIRECT') == 1) {
			
			$fields = array( "PS_RESPONSE_DATE" => new DateTime());

			$is_part_refunted = $gateResponse['paymentAmountInfo']['approvedAmount'] === $gateResponse['amount'] && $gateResponse['paymentAmountInfo']['refundedAmount'] != 0;
			$is_full_refunded = $gateResponse['paymentAmountInfo']['approvedAmount'] === $gateResponse['paymentAmountInfo']['refundedAmount'];


			if($is_full_refunded) {
				$fields['PS_STATUS_MESSAGE'] = Loc::getMessage('RBS_PAYMENT_REFUNDED_FULL_MESSAGE') . ($gateResponse['amount'] / 100) . Loc::getMessage('RBS_PAYMENT_R');
			} else if($is_part_refunted) {
				$fields['PS_STATUS_MESSAGE'] = Loc::getMessage('RBS_PAYMENT_REFUNDED_MESSAGE') . ($gateResponse['paymentAmountInfo']['refundedAmount'] / 100) . Loc::getMessage('RBS_PAYMENT_R');
			}

			if ($is_need_payment_cancel && $is_full_refunded) {
				$result->setOperationType(PaySystem\ServiceResult::MONEY_LEAVING);
			}

			$result->setPsData($fields);
		}


        // Change order status
		if ($request->get('CALLBACK_REDIRECT') == 1) {

			// set order status
			$option_order_status = unserialize(Option::get($moduleId, 'CALLBACK_ACTION_ORDER_STATUS'));
			$new_status = $option_order_status[$operation_name];

			$is_need_change_status = true;

			if ($gateResponse['orderStatus'] === 4 && $gateResponse['paymentAmountInfo']['depositedAmount'] > 0) {
				$is_need_change_status = false;
			}
			if ($new_status != 'FALSE' && $is_need_change_status) {
				$statuses = array();
				$dbStatus = \CSaleStatus::GetList(array("SORT" => "ASC"), array("LID" => LANGUAGE_ID), false, false, array("ID", "NAME", "SORT"));
				while ($arStatus = $dbStatus->GetNext()) {
					$statuses[$arStatus["ID"]] = "[" . $arStatus["ID"] . "] " . $arStatus["NAME"];
				}

				if (array_key_exists($new_status, $statuses)) {
					$order->setField('STATUS_ID', $new_status);
				} else {
					echo '<span style="display:block; font-size:16px; display:block; color:red;padding:20px 0;">ERROR! CANT CHANGE ORDER STATUS</span>';
				}
			}

			$order->save();

			require dirname(dirname(__FILE__)) . '/config.php';
			if ($RBS_CONFIG['CALLBACK_BROADCAST']) {
				$broadcast_url = Option::get($moduleId, 'CALLBACK_REDIRECT_BROADCAST', '');
				$queryParams = $request->getRequestMethod() == 'GET' ? $request->getQueryList()->toArray() : $request->getPostList()->toArray();
				if (strlen($broadcast_url) > 5) {
					$RBS_Gateway->broadcast_callback($broadcast_url, $queryParams);
				}
			}

			return $result;
		}

		$order->save();

        $returnPage = $this->getBusinessValue($payment, 'RETURN_URL');
        $failPage = $this->getBusinessValue($payment, 'FAIL_URL');

        if(strlen($returnPage) > 4 && $successPayment) {
        	echo "<script>window.location='" .$returnPage."'</script>";
        } else if(strlen($failPage) > 4 && !$successPayment) {
        	echo "<script>window.location='" .$failPage."'</script>";
        } else {
			self::printResultText($payment,$successPayment);
        } 

       
        return $result;
	}


	public function getPaymentIdFromRequest(Request $request)
	{
	    $paymentId = $request->get('PAYMENT_ID');
	    return intval($paymentId);
	}

	public function getCurrencyList()
	{
		return array('RUB');
	}

	public static function getIndicativeFields()
	{
		return array('PAYMENT' => 'RBS');
	}

	static protected function isMyResponseExtended(Request $request, $paySystemId)
	{
		global $APPLICATION;

		$RBS_Gateway = new \Rbs\Payments\Gateway;

		if($request->get('OPERATION_CALLBACK') == 'RBS' && $request->get('CALLBACK_REDIRECT') != 1) {
			if(!$request->get('orderNumber')) {
				$RBS_Gateway->baseLogger('CALLBACK_RETURN', 'CALLBACK', $request->getQueryList(), [],'ERROR PROCESSING CALLBACK');
				return false;
			}

			$arrOrderIds = explode("_", $request->get('orderNumber') );
			array_pop($arrOrderIds);
			$R_PAYMENT_ID = array_pop($arrOrderIds);
			$R_ORDER_ID = implode('_', $arrOrderIds);

			if(!$R_ORDER_ID) {
				return false;
			}

			$order = is_numeric($R_ORDER_ID) ? Order::load($R_ORDER_ID) : false;

			if($order) {
				$paymentCollection = $order->getPaymentCollection();
				foreach ($paymentCollection as $payment) {
					if($R_PAYMENT_ID == $payment->getId()) {
						LocalRedirect($APPLICATION->GetCurUri("ORDER_ID=" . $payment->getOrderId() . "&PAYMENT_ID=" . $R_PAYMENT_ID . "&CALLBACK_REDIRECT=1" . "&operation=" . $request->get('operation') ));
					}
				}
			}

			$order = Order::loadByAccountNumber($R_ORDER_ID);
			if($order) {
				$paymentCollection = $order->getPaymentCollection();
				foreach ($paymentCollection as $payment) {
					if($R_PAYMENT_ID == $payment->getId()) {
						LocalRedirect($APPLICATION->GetCurUri("ORDER_ID=" . $payment->getOrderId() . "&PAYMENT_ID=" . $R_PAYMENT_ID . "&CALLBACK_REDIRECT=1" . "&operation=" . $request->get('operation')));
					}
				}
			} 
			if(!$order) {
				$RBS_Gateway->baseLogger('CALLBACK_RETURN', 'CALLBACK', $request->getQueryList(), [],'ERROR PROCESSING CALLBACK');
				return false;
			}
	    	return false;
		}


		if(!$request->get('ORDER_ID')) {
			return false;
		}
		$order = Order::load($request->get('ORDER_ID'));
		if($order) {
			$paymentIds = $order->getPaymentSystemId();
			if(in_array($paySystemId, $paymentIds)) {
				return true;
			}
		}
		if(!$order) {
			$order = Order::loadByAccountNumber($request->get('ORDER_ID'));
		} 
		if(!$order) {
			echo Loc::getMessage('RBS_MESSAGE_ERROR_BAD_ORDER');
			return false;
		}
		$paymentIds = $order->getPaymentSystemId();

		return in_array($paySystemId, $paymentIds);
	}

	private function getPropertyValueByCode($propertyCollection, $code) {
		$property = '';
		foreach ($propertyCollection as $property)
	    {
	        if($property->getField('CODE') == $code)
	            return $property->getValue();
	    }
	}

	/**
	 * @return array
	 */
	protected function getUrlList()
	{
		return array(

		);
	}

	/**
	 * @return array
	 */
	public function getProps()
	{
		$data = array();

		return $data;
	}

	/**
	 * @param Payment $payment
	 * @param Request $request
	 * @return bool
	 */
	public function initPrePayment(Payment $payment = null, Request $request)
	{
		return true;
	}

	/**
	 * @param array $orderData
	 */
	public function payOrder($orderData = array())
	{

	}

	/**
	 * @param array $orderData
	 * @return bool|string
	 */
	public function BasketButtonAction($orderData = array())
	{
		return true;
	}

	/**
	 * @param array $orderData
	 */
	public function setOrderConfig($orderData = array())
	{
		if ($orderData)
			$this->prePaymentSetting = array_merge($this->prePaymentSetting, $orderData);
	}

	protected function getOrderDescription(Payment $payment)
	{
		/** @var PaymentCollection $collection */
		$collection = $payment->getCollection();
		$order = $collection->getOrder();
		$userEmail = $order->getPropertyCollection()->getUserEmail();

		$description =  str_replace(
			array(
				'#PAYMENT_NUMBER#',
				'#ORDER_NUMBER#',
				'#PAYMENT_ID#',
				'#ORDER_ID#',
				'#USER_EMAIL#'
			),
			array(
				$payment->getField('ACCOUNT_NUMBER'),
				$order->getField('ACCOUNT_NUMBER'),
				$payment->getId(),
				$order->getId(),
				($userEmail) ? $userEmail->getValue() : ''
			),
			$this->getBusinessValue($payment, 'RBS_ORDER_DESCRIPTION')
		);

		$description = Main\Text\Encoding::convertEncoding($description, LANG_CHARSET, "UTF-8");
		return $description;
	}

	private static function encode(array $data)
	{
		return Main\Web\Json::encode($data, JSON_UNESCAPED_UNICODE);
	}

	protected function printResultText($payment,$successPayment)
	{
		global $APPLICATION;
		echo '<div class="rbs-center" style="width: 100%;display: flex;align-items: center;align-content: center;justify-content: center;height: 100%;position: fixed;"><div style="display: block;background:#fff;padding: 10px 10px; margin-left:-10px;border-radius: 6px;max-width: 400px; border: 1px solid #e7e7e7;">';
		echo '<div class="rbs-result-message" style="margin:5px; text-align:center;padding:10px 20px; 0"><span style=" font-family: arial;font-size: 16px;">';

	        if($successPayment) {
	        	$APPLICATION->SetTitle(Loc::getMessage('RBS_PAYMENT_MESSAGE_THANKS'));
	        	echo Loc::getMessage('RBS_PAYMENT_MESSAGE_THANKS_DESCRIPTION') . $this->getBusinessValue($payment, 'RBS_ORDER_NUMBER');
	        } else {
	        	$APPLICATION->SetTitle(Loc::getMessage('RBS_PAYMENT_MESSAGE_ERROR'));
	        	echo Loc::getMessage('RBS_PAYMENT_MESSAGE_ERROR') . ' #' . $this->getBusinessValue($payment, 'RBS_ORDER_NUMBER');
	        }
		echo '<div style=" display: block; margin:10px 10px 0;"><a style="font-family: arial;font-size: 16px;color: #0e6ce0;" href="/">' .  Loc::getMessage('RBS_RETURN_LINK'). '</a></div>';
	        echo "</span></div>";
		echo "</div></div>";
	}

	private function cancelOrder($paymentId) 
	{
		$order = Order::load($paymentId);
        $order->setField("CANCELED", "Y");
        $order->setField("REASON_CANCELED", 'Истекло время ожидания оплаты заказа.');
        $order->save();
	}

	private function getGateProdUrl($login,$prefix,$old_prod_url,$new_prod_url) {
		if(strlen($new_prod_url) > 0 && substr($login, 0, strlen($prefix)) == $prefix) {
			return $new_prod_url;
		}
		return $old_prod_url;
	}


	public function isRefundableExtended(){}
	public function confirm(Payment $payment){}
	public function cancel(Payment $payment){}
	public function refund(Payment $payment, $refundableSum){}
	public function sendResponse(PaySystem\ServiceResult $result, Request $request){}

	

}