<?php
	use Bitrix\Main;
	use Bitrix\Main\Loader;
	use Bitrix\Main\Config\Option;
	use Bitrix\Main\Localization\Loc;
	use Bitrix\Sale;

	require __DIR__ . '/config.php';

	$moduleID = $RBS_CONFIG['MODULE_ID'];

	Loader::includeModule('sale');
	Loader::includeModule('currency');
	Loader::includeModule($moduleID);

	$request = \Bitrix\Main\Application::getInstance()->getContext()->getRequest();

	IncludeModuleLangFile($_SERVER["DOCUMENT_ROOT"].BX_ROOT."/modules/main/options.php");
	IncludeModuleLangFile(__FILE__);
?>

<?	
	if ($REQUEST_METHOD == 'POST' && strlen($Update . $Apply) > 0 && check_bitrix_sessid()) {

		if($RBS_CONFIG['RBS_ENABLE_FES_CODES']) {
			$infoblock_id = $_POST['RBS_PAYMENT_INFOBLOCKS'][0] == 0 ? 0 : $_POST['RBS_PAYMENT_INFOBLOCKS'][0];


			if($infoblock_id != 0) {
				foreach ($_POST['RBS_PAYMENT_INFOBLOCKS'] as $key => $infoblock_id) {
					$infoblock_prop = CIBlockProperty::GetByID("FES_TRUCODE", $infoblock_id);

					$arFieldsCreditType = Array(
					  	"NAME" => GetMessage("RBS_PAYMENT_NAME_FES_TRUCODE"),
					  	"ACTIVE" => "Y",
					  	"SORT" => "3000",
					  	"CODE" => "FES_TRUCODE",
					  	"PROPERTY_TYPE" => "S",
					  	"MULTIPLE" => "N",
					  	"IBLOCK_ID" => $infoblock_id,
					);


					$ibp = new CIBlockProperty;
					
					if($prop_result = $infoblock_prop->GetNext()) {
						// $ibp->Update($prop_result['ID'], $arFieldsCreditType);
					} else {
						$PropID = $ibp->Add($arFieldsCreditType);	
					}

				}
			}
		}

		if($RBS_CONFIG['RBS_ENABLE_NOMECLATURE']) {
			$infoblock_id = $_POST['RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE'][0] == 0 ? 0 : $_POST['RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE'][0];
			$NOMECLATURE_CODE_VALUE = $_POST['NOMECLATURE_CODE_VALUE'];

			if($infoblock_id != 0) {
				foreach ($_POST['RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE'] as $key => $infoblock_id) {
					$infoblock_prop = CIBlockProperty::GetByID($NOMECLATURE_CODE_VALUE, $infoblock_id);

					$arFieldsCreditType = Array(
					  	"NAME" => GetMessage("RBS_PAYMENT_NAME_NOMENCLATURE"),
					  	"ACTIVE" => "Y",
					  	"SORT" => "3000",
					  	"CODE" => $NOMECLATURE_CODE_VALUE,
					  	"PROPERTY_TYPE" => "S",
					  	"MULTIPLE" => "N",
					  	"IBLOCK_ID" => $infoblock_id,
					);


					$ibp = new CIBlockProperty;
					
					if($prop_result = $infoblock_prop->GetNext()) {
						// $ibp->Update($prop_result['ID'], $arFieldsCreditType);
					} else {
						$PropID = $ibp->Add($arFieldsCreditType);	
					}

				}
			}
		}

		COption::SetOptionString($moduleID, "TAX_DEFAULT", $_POST['TAX_DEFAULT']);
	    COption::SetOptionString($moduleID, "RESULT_ORDER_STATUS", 'FALSE');
	    COption::SetOptionString($moduleID, "OPTION_EMAIL", $_POST['OPTION_EMAIL']);
	    COption::SetOptionString($moduleID, "OPTION_PHONE", $_POST['OPTION_PHONE']);
	    COption::SetOptionString($moduleID, "OPTION_FIO", $_POST['OPTION_FIO']);
	    COption::SetOptionString($moduleID, "CANCEL_ORDER_BY_TIMEOUT", $_POST['CANCEL_ORDER_BY_TIMEOUT'] === 'on' ? true : false);
	    COption::SetOptionString($moduleID, "CLIENT_LINK_ENABLE", $_POST['CLIENT_LINK_ENABLE'] === 'on' ? true : false);
		COption::SetOptionString($moduleID, "CALLBACK_ACTIONS", serialize($_POST['CALLBACK_ACTIONS']));
		COption::SetOptionString($moduleID, "CALLBACK_ACTION_ORDER_STATUS", serialize($_POST['CALLBACK_ACTION_ORDER_STATUS']));
		COption::SetOptionString($moduleID, "CANCEL_PAYMENT_BY_REFUNDED", $_POST['CANCEL_PAYMENT_BY_REFUNDED'] === 'on' ? true : false);
		
		if($RBS_CONFIG['RBS_ENABLE_FES_CODES']) {
			COption::SetOptionString($moduleID, "RBS_PAYMENT_INFOBLOCKS", serialize($_POST['RBS_PAYMENT_INFOBLOCKS']));
		}
		if($RBS_CONFIG['RBS_ENABLE_NOMECLATURE']) {
			COption::SetOptionString($moduleID, "RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE", serialize($_POST['RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE']));
			COption::SetOptionString($moduleID, "NOMECLATURE_CODE_VALUE", $_POST['NOMECLATURE_CODE_VALUE']);
		}

		if ($RBS_CONFIG['CALLBACK_BROADCAST']) {
			COption::SetOptionString($moduleID, "CALLBACK_REDIRECT_BROADCAST", $_POST['CALLBACK_REDIRECT_BROADCAST']);
		}
	}


	$current_settings = array(
		'BANK_NAME' => COption::GetOptionString($moduleID, 'BANK_NAME'),
		'MODULE_ID' => COption::GetOptionString($moduleID, 'MODULE_ID'),
		'RBS_PROD_URL' => COption::GetOptionString($moduleID, 'RBS_PROD_URL'),
		'RBS_TEST_URL' => COption::GetOptionString($moduleID, 'RBS_TEST_URL'),
		'MODULE_VERSION' => COption::GetOptionString($moduleID, 'MODULE_VERSION'),
		'TAX_DEFAULT' => COption::GetOptionString($moduleID, 'TAX_DEFAULT'),
		'ISO' => unserialize(COption::GetOptionString($moduleID, 'ISO')),
		'RESULT_ORDER_STATUS' => COption::GetOptionString($moduleID, 'RESULT_ORDER_STATUS'),
		'OPTION_EMAIL' => COption::GetOptionString($moduleID, 'OPTION_EMAIL'),
		'OPTION_PHONE' => COption::GetOptionString($moduleID, 'OPTION_PHONE'),
		'OPTION_FIO' => COption::GetOptionString($moduleID, 'OPTION_FIO'),
		'CANCEL_ORDER_BY_TIMEOUT' => COption::GetOptionString($moduleID, 'CANCEL_ORDER_BY_TIMEOUT'),
		'CLIENT_LINK_ENABLE' => COption::GetOptionString($moduleID, 'CLIENT_LINK_ENABLE'),
		'CALLBACK_ACTIONS' => unserialize(COption::GetOptionString($moduleID, 'CALLBACK_ACTIONS')),
		'CALLBACK_ACTION_ORDER_STATUS' => unserialize(COption::GetOptionString($moduleID, 'CALLBACK_ACTION_ORDER_STATUS')),
		'CANCEL_PAYMENT_BY_REFUNDED' => COption::GetOptionString($moduleID, 'CANCEL_PAYMENT_BY_REFUNDED'),
		'RBS_PAYMENT_INFOBLOCKS' => unserialize(COption::GetOptionString($moduleID, 'RBS_PAYMENT_INFOBLOCKS'), []),
		'RBS_ENABLE_FES_CODES' => COption::GetOptionString($moduleID, 'RBS_ENABLE_FES_CODES'),

		'RBS_ENABLE_NOMECLATURE' => COption::GetOptionString($moduleID, 'RBS_ENABLE_NOMECLATURE'),
		'RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE' => unserialize(COption::GetOptionString($moduleID, 'RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE'), []),
		'NOMECLATURE_CODE_VALUE' => COption::GetOptionString($moduleID, 'NOMECLATURE_CODE_VALUE')
	);


	$order_status_list = array();
	$dbStatus = CSaleStatus::GetList(array("SORT" => "ASC"), array("LID" => LANGUAGE_ID), false, false, array("ID", "NAME", "SORT"));
	while ($arStatus = $dbStatus->GetNext()) {
		$order_status_list[$arStatus["ID"]] = "[" . $arStatus["ID"] . "] " . $arStatus["NAME"];
	}

	if ($current_settings['RESULT_ORDER_STATUS'] !== 'FALSE') {
		$current_settings['CALLBACK_ACTION_ORDER_STATUS']['deposited'] = $current_settings['RESULT_ORDER_STATUS'];
		$current_settings['CALLBACK_ACTION_ORDER_STATUS']['approved'] = $current_settings['RESULT_ORDER_STATUS'];
	}
?>


<?
	$tabControl = new CAdminTabControl("tabControl",  array(
		array("DIV" => "edit1", "TAB" => Loc::getMessage('RBS_TAB_NAME'), "ICON" => "blog_settings", "TITLE" => Loc::getMessage('RBS_TAB_TITLE')),
	));
	$tabControl->Begin();
?>


<form method="POST" action="<?echo $APPLICATION->GetCurPage()?>?mid=<?=htmlspecialcharsbx($mid)?>&lang=<?=LANGUAGE_ID?>">
	<?= bitrix_sessid_post() ?>
	<? $tabControl->BeginNextTab(); ?>
	
		
		<!-- MODULE BASE INFO -->

		<tr class="heading">
	        <td colspan="2"><?= Loc::getMessage('RBS_STRING_MODULE_INFO')?>:</td>
	    </tr>
	    <tr>
	        <td width="50%"><?= Loc::getMessage('RBS_STRING_BANK')?></td>
	        <td width="50%"><span><?=$current_settings['BANK_NAME']?></span></td>
	    </tr>
	    <tr>
	        <td width="50%"><?= Loc::getMessage('RBS_STRING_MODULE_VERSION')?>:</td>
	        <td width="50%"><span><?=$current_settings['MODULE_VERSION']?></span></td>
	    </tr>

		<!-- TAX DEFAULT -->

		<tr class="heading">
	        <td colspan="2"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT')?>:</td>
	    </tr>
		<tr>

	        <td width="100%" colspan="2" style="text-align: center;">
	            <select name="TAX_DEFAULT">
	            	<option <?= 0 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="0"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_0');?></option>
	            	<option <?= 1 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="1"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_1');?></option>
	            	<option <?= 2 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="2"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_2');?></option>
	            	<option <?= 4 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="4"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_4');?></option>
	            	<option <?= 6 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="6"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_6');?></option>
	            	<option <?= 7 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="7"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_7');?></option>
	            	<option <?= 10 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="10"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_10'); ?></option>
					<option <?= 11 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="11"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_11'); ?></option>
					<option <?= 12 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="12"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_12'); ?></option>
					<option <?= 13 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="13"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_13'); ?></option>
                    <option <?= 14 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="14"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_14'); ?></option>
                    <option <?= 15 == $current_settings['TAX_DEFAULT'] ? ' selected' : '' ?> value="15"><?= Loc::getMessage('RBS_STRING_TAX_DEFAULT_VALUE_15'); ?></option>

	            </select>
	        </td>
	    </tr>


		<tr class="heading">
	        <td colspan="2"><?= Loc::getMessage('RBS_STRING_CUSTOM_OPTIONS')?>:</td>
	    </tr>

		<tr>
			<td colspan="2">
				<div class="adm-info-message" style="margin-bottom: 5px; max-width: 500px; margin-left: auto; margin-right: auto; display: block; margin-top: 0;">
					<?= Loc::getMessage('RBS_STRING_CUSTOM_OPTIONS_DESCRIPTION');?>
				</div>
			</td>
		</tr>

		
		<tr class="extra-settings active">
	        <td width="50%" class="adm-detail-content-cell-l">
	        	<?= Loc::getMessage('RBS_STRING_OPTION_PHONE')?>
	        </td>
	        <td width="50%" class="rbs-input-top adm-detail-content-cell-r">
	        	<input type="text" name="OPTION_PHONE" value="<?=$current_settings['OPTION_PHONE']?>">
	        </td>
	    </tr>
	    <tr class="extra-settings active">
	        <td width="50%" class="adm-detail-content-cell-l">
	        	<?= Loc::getMessage('RBS_STRING_OPTION_EMAIL')?>
	        </td>
	        <td width="50%" class="rbs-input-top adm-detail-content-cell-r">
	        	<input type="text" name="OPTION_EMAIL" value="<?=$current_settings['OPTION_EMAIL']?>">
	        </td>
	    </tr>
	    <tr class="extra-settings active">
	        <td width="50%" class="adm-detail-content-cell-l">
	        	<?= Loc::getMessage('RBS_STRING_OPTION_FIO')?>
	        </td>
	        <td width="50%" class="rbs-input-top adm-detail-content-cell-r">
	        	<input type="text" name="OPTION_FIO" value="<?=$current_settings['OPTION_FIO']?>">
	        </td>
	    </tr>



		<!-- CALLBAKS -->

		<tr class="heading">
			<td colspan="2"><?= Loc::getMessage('RBS_PAYMENT_TITLE_CALLBACKS') ?><br><?= Loc::getMessage('RBS_PAYMENT_TITLE_CALLBACKS2'); ?></td>
		</tr>

		<tr class="callback-settings">
			<td width="50%" class="adm-detail-content-cell-l">
				<?= Loc::getMessage('RBS_PAYMENT_CALLBACK_SUBTITLE_EVENT'); ?>
			</td>
			<td width="50%" class="rbs-input-top adm-detail-content-cell-r">
				<?= Loc::getMessage('RBS_PAYMENT_CALLBACK_SUBTITLE_STATUS'); ?>
			</td>
		</tr>
		<tr class="callback-settings callback-s">
			<td width="50%" class="adm-detail-content-cell-l callback-item">
				<label>
					<input type="checkbox" name="CALLBACK_ACTIONS[deposited]" <? if ($current_settings['CALLBACK_ACTIONS']['deposited']) echo 'checked'; ?>>
					<span><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_DEPOSITED'); ?></span>
				</label>
			</td>
			<td width="50%" class="rbs-input-top adm-detail-content-cell-r">
				<select name="CALLBACK_ACTION_ORDER_STATUS[deposited]">
					<option value="0" <?= 0 == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['deposited'] ? ' selected' : '' ?>><?= Loc::getMessage('RBS_ORDER_STATUS_FALSE') ?></option>
					<? foreach ($order_status_list as $key => $name) { ?>
						<option value="<?= $key ?>" <?= $key == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['deposited'] ? ' selected' : '' ?>><?= htmlspecialcharsex($name) ?></option>
					<? } ?>
				</select>
				<p class="callback-item-message"><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_DEPOSITED_DESCRIPTION'); ?></p>
			</td>
		</tr>

		<tr class="callback-settings callback-s">
			<td width="50%" class="adm-detail-content-cell-l callback-item">
				<label>
					<input type="checkbox" name="CALLBACK_ACTIONS[approved]" <? if ($current_settings['CALLBACK_ACTIONS']['approved']) echo 'checked'; ?>>
					<span><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_APPROVED'); ?></span>
				</label>
			</td>
			<td width="50%" class="rbs-input-top adm-detail-content-cell-r">
				<select name="CALLBACK_ACTION_ORDER_STATUS[approved]">
					<option value="0" <?= 0 == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['approved'] ? ' selected' : '' ?>><?= Loc::getMessage('RBS_ORDER_STATUS_FALSE') ?></option>
					<? foreach ($order_status_list as $key => $name) { ?>
						<option value="<?= $key ?>" <?= $key == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['approved'] ? ' selected' : '' ?>><?= htmlspecialcharsex($name) ?></option>
					<? } ?>
				</select>
			</td>
		</tr>

		<tr class="callback-settings callback-s">
			<td width="50%" class="adm-detail-content-cell-l callback-item">
				<label>
					<input type="checkbox" name="CALLBACK_ACTIONS[reversed]" <? if ($current_settings['CALLBACK_ACTIONS']['reversed']) echo 'checked'; ?>>
					<span><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_REVERSED'); ?></span>
				</label>
			</td>
			<td width="50%" class="rbs-input-top adm-detail-content-cell-r">
				<select name="CALLBACK_ACTION_ORDER_STATUS[reversed]">
					<option value="0" <?= 0 == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['reversed'] ? ' selected' : '' ?>><?= Loc::getMessage('RBS_ORDER_STATUS_FALSE') ?></option>
					<? foreach ($order_status_list as $key => $name) { ?>
						<option value="<?= $key ?>" <?= $key == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['reversed'] ? ' selected' : '' ?>><?= htmlspecialcharsex($name) ?></option>
					<? } ?>
				</select>
			</td>
		</tr>

		<tr class="callback-settings callback-s">
			<td width="50%" class="adm-detail-content-cell-l callback-item">
				<label>
					<input type="checkbox" name="CALLBACK_ACTIONS[refunded]" <? if ($current_settings['CALLBACK_ACTIONS']['refunded']) echo 'checked'; ?>>
					<span><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_REFUNDED'); ?></span>
				</label>
			</td>
			<td width="50%" class="rbs-input-top adm-detail-content-cell-r">
				<select name="CALLBACK_ACTION_ORDER_STATUS[refunded]">
					<option value="0" <?= 0 == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['refunded'] ? ' selected' : '' ?>><?= Loc::getMessage('RBS_ORDER_STATUS_FALSE') ?></option>
					<? foreach ($order_status_list as $key => $name) { ?>
						<option value="<?= $key ?>" <?= $key == $current_settings['CALLBACK_ACTION_ORDER_STATUS']['refunded'] ? ' selected' : '' ?>><?= htmlspecialcharsex($name) ?></option>
					<? } ?>
				</select>
				<div class="cancel-payment-by-refunnded">
					<input type="checkbox" name="CANCEL_PAYMENT_BY_REFUNDED" <? if ($current_settings['CANCEL_PAYMENT_BY_REFUNDED']) echo 'checked'; ?>>
					<p class="callback-item-message"><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_REFUNDED_DESCRIPTION'); ?></p>
				</div>
			</td>
		</tr>

		<tr class="callback-settings callback-s">
			<td width="50%" class="adm-detail-content-cell-l callback-item" style="padding-top:10px;">
				<label>
					<input type="checkbox" name="CALLBACK_ACTIONS[declinedByTimeout]" <? if ($current_settings['CALLBACK_ACTIONS']['declinedByTimeout']) echo 'checked'; ?>>
					<span><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_DECLINEDBYTIMEOUT'); ?></span>
				</label>
			</td>
			<td width="50%" class="rbs-input-top adm-detail-content-cell-r">
				<input type="checkbox" name="CANCEL_ORDER_BY_TIMEOUT" <? if ($current_settings['CANCEL_ORDER_BY_TIMEOUT']) echo 'checked'; ?>>
				<span><?= Loc::getMessage('RBS_PAYMENT_CALLBACK_OPERATION_DECLINEDBYTIMEOUT_DESCRIPTION'); ?></span>
			</td>
		</tr>


	    <!-- FES  -->

		<? if($RBS_CONFIG['RBS_ENABLE_FES_CODES']) { ?>
			<tr class="heading">
		        <td colspan="2"><?= GetMessage('RBS_PAYMENT_OPTIONS_INFOBLOCK_TITLE');?></td>
		    </tr>
		    <tr class="extra-settings active">
		        <td width="50%" class="adm-detail-content-cell-l">
		        	<?= GetMessage('RBS_PAYMENT_OPTIONS_INFOBLOCK_LABEL');?>
		        	<span class="rbs-input-description"><span>
		        		<?= GetMessage('RBS_PAYMENT_OPTIONS_INFOBLOCK_DESCRIPTION');?>
		        	</span></span>
		        </td>
		        <td width="50%" class="rbs-input-top adm-detail-content-cell-r">
					<?php
						$arCatalog_list = CIBlock::GetList(
						    Array(), 
						    Array(
						        // 'TYPE'=>'catalog', 
						        'ACTIVE'=>'Y', 
						    ), true
						);
					?>
					<select name="RBS_PAYMENT_INFOBLOCKS[]" size="5" multiple>
						<?php while($arCatalogItem = $arCatalog_list->Fetch()) { ?>
							<option value="<?=$arCatalogItem['ID']?>" <?=(in_array($arCatalogItem['ID'], $current_settings['RBS_PAYMENT_INFOBLOCKS'] ?? []) ? 'selected' : '')?>>
								<?=$arCatalogItem['NAME']?>
							</option>
						<? } ?>
	                </select>
		        </td>
		    </tr>
	    <? } ?>

	    <!-- NOMENCLATURE  -->

		<? if($RBS_CONFIG['RBS_ENABLE_NOMECLATURE']) { ?>
			<tr class="heading">
		        <td colspan="2"><?= GetMessage('RBS_PAYMENT_OPTIONS_INFOBLOCK_TITLE2');?></td>
		    </tr>
		    <tr class="extra-settings active">
		        <td width="50%" class="adm-detail-content-cell-l">
		        	<?= GetMessage('RBS_PAYMENT_OPTIONS_INFOBLOCK_LABEL2');?>
		        	<span class="rbs-input-description"><span>
		        		<?= GetMessage('RBS_PAYMENT_OPTIONS_INFOBLOCK_DESCRIPTION2');?>
		        	</span></span>
		        </td>
		        <td width="50%" class="rbsbank-input-top adm-detail-content-cell-r">
					<?php
						$arCatalog_list = CIBlock::GetList(
						    Array(), 
						    Array(
						        // 'TYPE'=>'catalog', 
						        'ACTIVE'=>'Y', 
						    ), true
						);
					?>
					<select name="RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE[]" size="5" multiple>
						<?php while($arCatalogItem = $arCatalog_list->Fetch()) { ?>
							<option value="<?=$arCatalogItem['ID']?>" <?=(in_array($arCatalogItem['ID'], $current_settings['RBS_PAYMENT_INFOBLOCKS_NOMENCLATURE'] ?? []) ? 'selected' : '')?>>
								<?=$arCatalogItem['NAME']?>
							</option>
						<? } ?>
	                </select>
		        </td>
		    </tr>
		    <tr class="extra-settings active">
				<td width="50%" class="adm-detail-content-cell-l">
					<?= Loc::getMessage('RBS_PAYMENT_NOMENCLATURE_CODE_NAME') ?>
				</td>
				<td width="50%" class="rbsbank-input-top adm-detail-content-cell-r">
					<input type="text" name="NOMECLATURE_CODE_VALUE" value="<?= $current_settings['NOMECLATURE_CODE_VALUE'] ?>">
				</td>
			</tr>
	    <? } ?>

	    <? if($RBS_CONFIG['CALLBACK_BROADCAST']) { ?>
		    
		    <!-- CALLBACK_REDIRECT_BROADCAST -->
			<tr class="heading">
		        <td colspan="2"><?= Loc::getMessage('RBS_CALLBACK_REDIRECT_BROADCAST_DESCRIPTION')?>:</td>
		    </tr>
			<tr>

		        <td width="100%" colspan="2" style="text-align: center;">
		            <input type="text" size="50" name="CALLBACK_REDIRECT_BROADCAST" value="<?=$current_settings['CALLBACK_REDIRECT_BROADCAST']?>">
		        </td>
		    </tr>
			<tr>
				<td colspan="2">
					<div class="adm-info-message" style="margin-top: 15px; max-width: 200px; margin-left: auto; margin-right: auto; display: block; text-align:center;">
						Example: http://test.ru/
					</div>
				</td>
			</tr>

		<? } ?>

	    <!-- TEST SERVER PHP,CURL,TLS -->

	    <? if ($_REQUEST['server_info'] == '1') { ?>
		    <tr class="heading">
		        <td colspan="2"><?= Loc::getMessage('RBS_STRING_SERVER_INFO')?>:</td>
		    </tr>
			<?
					$server_info = array();
					$server_info[] = array("PHP version:", phpversion() );
				    if (function_exists('curl_version')) {
				        $curl = curl_version();
				        $server_info[] = array("cURL version:", $curl["version"] );
				        $ch = curl_init('https://www.howsmyssl.com/a/check');
				        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				        $data = curl_exec($ch);
				        curl_close($ch);
				        $json = json_decode($data);
				        $server_info[] = array("TLS version: ", $json->tls_version );
				    } else {
				    	$server_info[] = array("PHP version:", phpversion() );
				    	$server_info[] = array("cURL", 'Not installed!!!' );
				    }
				    $server_info[] = array("OpenSSL version text: ", OPENSSL_VERSION_TEXT );
				    $server_info[] = array("OpenSSL version number: ", OPENSSL_VERSION_NUMBER );
				
			?>
			<? foreach ($server_info as $key => $item) { ?>
			    <tr>
			        <td width="50%"><?=$item[0]?></td>
			        <td width="50%"><?=$item[1]?></td>
			    </tr>
			<? } ?>
		<? } ?>
		
	<? $tabControl->BeginNextTab(); ?>
    <? $tabControl->Buttons(); ?>
		<input type="submit" name="Update" value="<?= GetMessage("MAIN_SAVE") ?>" title="<?= GetMessage("MAIN_OPT_SAVE_TITLE") ?>" class="adm-btn-save">
		<input type="submit" name="Apply" value="<?= GetMessage("MAIN_OPT_APPLY") ?>" title="<?= GetMessage("MAIN_OPT_APPLY_TITLE") ?>">
		<? if (strlen($_REQUEST["back_url_settings"]) > 0): ?>
	        <input type="button" name="Cancel" value="<?= GetMessage("MAIN_OPT_CANCEL") ?>"
	               title="<?= GetMessage("MAIN_OPT_CANCEL_TITLE") ?>"
	               onclick="window.location='<? echo htmlspecialcharsbx(CUtil::addslashes($_REQUEST["back_url_settings"])) ?>'">
	        <input type="hidden" name="back_url_settings" value="<?= htmlspecialcharsbx($_REQUEST["back_url_settings"]) ?>">
	    <? endif ?>

	    <input type="button" id="check_server_info" value="Check server info">
	    <script>
	    	 BX.ready(function () {
	            var oButtonCheck = document.getElementById('check_server_info');
	            if (oButtonCheck) {
	                oButtonCheck.onclick = function () {
	                	window.location = '<?echo $APPLICATION->GetCurPage()?>?mid=<?=htmlspecialcharsbx($mid)?>&lang=<?=LANGUAGE_ID?><?echo "&server_info=1"?>';
	                    return false;
	                }
	            }
	        });
	    </script>
    <? $tabControl->End(); ?>
</form>
<style>
	.rbs-input-description {
		display: block;
		margin:10px 0 0;
		font-size: 12px;
		text-align: right;
	}
	.rbs-input-description span {
		display: inline-block;
		vertical-align: top;
		max-width: 300px;
		text-align: left;
		line-height: 15px;
	}
</style>
<style type="text/css">
	.callback-item {
		vertical-align: top;

	}

	.callback-item>label {
		padding-top: 5px;
		display: inline-block;
	}

	.callback-s td {
		border-bottom: 1px solid #ccc;
		padding: 14px 10px;
	}

	.callback-item-message {
		padding: 4px 0;
		margin: 0;
	}

	.cancel-payment-by-refunnded {
		display: flex;
		align-items: center;
		gap: 5px;
	}
</style>