<?php
	IncludeModuleLangFile(__FILE__);
?>
<div class="rbs__wrapper">
	<div class="rbs__content">
		<?php if (in_array($params['rbs_result']['errorCode'], array(999, 1, 2, 3, 4, 5, 7, 8, 10))) { ?>
			<span class="rbs__description"><?=getMessage("RBS_DESCRIPTION");?>:</span>
			<span class="rbs__error-code"><?=getMessage("RBS_ERROR_TITLE");?><?=$params['rbs_result']['errorCode']?></span>
			<span class="rbs__error-message"><?=$params['rbs_result']['errorMessage']?></span>

		<?php } else if ($params['rbs_result']['payment'] == 1) { ?>

			<span class="rbs__error-message"><?=getMessage("RBS_MESSAGE_PAYMENT_ALLREADY");?></span>

		<?php } else if ($params['rbs_result']['errorCode'] == 0) { ?>

			<? if($params['HANDLER_AUTO_REDIRECT'] == 'Y') {?>
				<script>window.location = '<?=$params['payment_link']?>';</script>
			<?php } ?>

			<span class="rbs__price-string"><?=getMessage("RBS_PAYMENT_TITLE");?>: <b><?=CurrencyFormat($params['RBS_ORDER_AMOUNT'], $params['currency'])?></b></span>
			<a href="<?=$params['payment_link']?>" class="rbs__payment-link"><?=getMessage("RBS_PAYMENT_BUTTON_NAME");?></a>
			<span class="rbs__payment-description"><?=getMessage("RBS_PAYMENT_DESCRIPTION");?></span>

		<?php } else { ?>
			<span class="rbs__error-message"><?=getMessage("RBS_ERROR_MESSAGE_UNDEFIND");?></span>

		<?php } ?>
	</div>
	<div class="rbs__footer">
		<span class="rbs__description"><?=getMessage("RBS_FOOTER_DESCRIPTION");?></span>
	</div>
</div>

<style>
	body .rbs__wrapper {
		font-family: arial;
		text-align: left;
		margin-bottom: 20px;
		margin-top: 20px;
	}
	body .rbs__price-block {
		font-family: arial;
		display: block;
		margin: 20px 0px;
	}
	body .rbs__price-string {
		font-family: arial;
		font-weight: bold;
		font-size: 14px;
	}
	body .rbs__price-string b {
		font-family: arial;
		font-size: 20px;
	}
	body .rbs__content {
		font-family: arial;
	    max-width: 400px;
	    width: 100%;
	    padding: 10px 10px 13px;
	    border: 1px solid #e5e5e5;
	    text-align: center;
	    margin-bottom: 12px;
	    display: flex;
	    flex-direction: column;
	    align-items: center;
	}
	body .rbs__payment-link {
		font-family: arial;
		display: inline-block;
		width: 100% ;
		max-width: 320px;
		margin: 8px 0 5px;
		background-color: #1eb42f !important;
		color: #fff !important;
		border:none;
		box-shadow: none;
    	outline: none;
    	font-size: 14px;
	    font-weight: normal;
	    line-height: 1.42857143;
	    text-align: center;
    	white-space: nowrap;
    	vertical-align: middle;
    	padding: 6px 12px;
    	text-decoration: none !important;
	}
	body .rbs__payment-link:hover {
		font-family: arial;
		background: #2db209;
		color: #fff;
	}
	body .rbs__payment-description {
		font-family: arial;
		display: block;
		font-size: 12px;
		color: #939393;
	}
	body .rbs__description {
		font-family: arial;
		font-size: 12px;
		max-width: 400px;
		display: block;
	}
	body .rbs__error-code {
		font-family: arial;
		color: red;
		font-size: 20px;
		display: block;
		margin-top:5px;
		margin-bottom: 7px;
	}
	body .rbs__error-message {
		font-family: arial;
		color:#000;
		font-size: 14px;
		display: block;
	}
	@media(max-width: 500px) {
		body .rbs__price-string  b{
		font-family: arial;
		font-weight: bold;
		font-size: 14px;
		}

	}
</style>